///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// ColumnFilterEditor
///////////////////////////////////////////////////////////////////////////////
 
var tDTP = new DateTimeParser();

ColumnFilterEditor.MAX_AGGBYS = 5;

function valueKeyPress(event)
{
   // Check for enter key
   if (event.keyCode == 13)
   {
      event.returnValue=false;
      saw.stopEventPropagation(event);
      ColumnFilterEditor.onAddExpr('idColumnFilter','sawx:untypedLiteral');
   }
}

//-------------------
// bCondition is true if editing a conditional formatting filter
// bNoPromptedOp = true means do not show the isPrompted operator
function ColumnFilterEditor(eid, bCondition, bIsListFormat, bNoPromptedOp)
{
	this.form = document.getElementById(eid + "Form");
	if (this.form == null)
		alert('Column Filter Editor Template not found on page.  ID = ' + eid + 'Form');

   this.myId = eid;
	this.valuesTable = document.getElementById(eid + 'ValuesTable');

	this.choicesForm = document.getElementById(eid + 'ChoicesFormId');
	this.choicesSide = document.getElementById(eid + 'ChoicesSide');
	this.matchTable = document.getElementById(eid + 'MatchTable');
	this.betweenTable = document.getElementById(eid + 'BetweenTable');
	this.aggByTable = document.getElementById(eid + 'AggByTable');
	this.aggByTableLink = document.getElementById(eid + 'AggByTableLink');

	this.choicesDiv = document.getElementById(eid + 'ChoicesDiv');

	this.conditionalFormatting = bCondition;

   if (null != bIsListFormat && bIsListFormat == true)
   {
      this.bIsListFormat = true;
		this.webExpressionSelector = new WebExpressionSelector('idWebExprSelector');
   }
   
   if (null != bNoPromptedOp && bNoPromptedOp == true)
     this.bNoPromptedOp = true;
     
   var tAdvancedMenuSpan = document.getElementById(eid+'ExtraButtonSpan');
   
   if(tAdvancedMenuSpan != undefined)
   {
      // for conditional formatting, hide the advanced button
      tAdvancedMenuSpan.style.display = (!this.conditionalFormatting)?"block":"none";
   }
}


ColumnFilterEditor.prototype = new XUIEditor();

//-------------------
// Set the operators into an associative array.  Singleton that sets opArray
ColumnFilterEditor.initializeOperatorList = function()
{
	if (ColumnFilterEditor.opArray == undefined)
	{
		var a = new Array;

		a['in'] = {op:'in', xsiType:'sawx:list', minValues:1, maxValues:9999,
		   display:kmsgFilterUIOperatorIN, conditional:true};

		//a['equal'] = {op:'equal', xsiType:'sawx:list', minValues:1, maxValues:9999,
		   //display:kmsgFilterUIOperatorIN, conditional:true};

		a['notIn'] = {op:'notIn', xsiType:'sawx:list', minValues:1, maxValues:9999,
		   display:kmsgFilterUIOperatorNIN, conditional:true};

      a['less'] = {op:'less', xsiType:'sawx:comparison', minValues:1, maxValues:1,
		   display:kmsgFilterUIOperatorLT, conditional:true};

      a['greater'] = {op:'greater', xsiType:'sawx:comparison', minValues:1, maxValues:1,
		   display:kmsgFilterUIOperatorGT, conditional:true};

      a['lessOrEqual'] = {op:'lessOrEqual', xsiType:'sawx:comparison', minValues:1, maxValues:1,
		   display:kmsgFilterUIOperatorLE, conditional:true};

      a['greaterOrEqual'] = {op:'greaterOrEqual', xsiType:'sawx:comparison', minValues:1, maxValues:1,
		   display:kmsgFilterUIOperatorGE, conditional:true};

      a['between'] = {op:'between', xsiType:'sawx:comparison', minValues:2, maxValues:2,
		   display:kmsgFilterUIOperatorBETWEEN, conditional:true};

      a['null'] = {op:'null', xsiType:'sawx:comparison', minValues:0, maxValues:0,
		   display:kmsgFilterUIOperatorISNULL, conditional:true};

      a['notNull'] = {op:'notNull', xsiType:'sawx:comparison', minValues:0, maxValues:0,
		   display:kmsgFilterUIOperatorISNOTNULL, conditional:true};

      a['top'] = {op:'top', xsiType:'sawx:rank', minValues:1, maxValues:1,
		   display:kmsgFilterUIOperatorISINTOP, choices:false};

      a['bottom'] = {op:'bottom', xsiType:'sawx:rank', minValues:1, maxValues:1,
		   display:kmsgFilterUIOperatorISINBOTTOM, choices:false};

      a['containsAll'] = {op:'containsAll', xsiType:'sawx:list', minValues:1, maxValues:9999,
		   display:kmsgFilterUIOperatorCONTAINSALL, textOnly:true};

      a['containsAny'] = {op:'containsAny', xsiType:'sawx:list', minValues:1, maxValues:9999,
		   display:kmsgFilterUIOperatorCONTAINSANY, textOnly:true};

      a['notContains'] = {op:'notContains', xsiType:'sawx:list', minValues:1, maxValues:9999,
		   display:kmsgFilterUIOperatorNOTCONTAINS, textOnly:true};

      a['beginsWith'] = {op:'beginsWith', xsiType:'sawx:list', minValues:1, maxValues:9999,
		   display:kmsgFilterUIOperatorBEGINSWITH, textOnly:true};

      a['endsWith'] = {op:'endsWith', xsiType:'sawx:list', minValues:1, maxValues:9999,
		   display:kmsgFilterUIOperatorENDSWITH, textOnly:true};

      a['like'] = {op:'like', xsiType:'sawx:list', minValues:1, maxValues:9999,
		   display:kmsgFilterUIOperatorISLIKE, textOnly:true};

      a['notLike'] = {op:'notLike', xsiType:'sawx:list', minValues:1, maxValues:9999,
		   display:kmsgFilterUIOperatorISNOTLIKE, textOnly:true};

      // This puts up a message box: var tEditor = XUIPanel.getEditor('idFilter');
      var tEditorDiv = document.getElementById('idFilterDiv');
      var tEditor = (null != tEditorDiv) ? tEditorDiv.editor : null;
      
      if (!(null != tEditor && tEditor.bIsListFormat))
      {
         a['prompted'] = {op:'prompted', xsiType:'sawx:special', minValues:0, maxValues:0,
		      display:kmsgFilterUIOperatorISPROMPTED};
      }

		ColumnFilterEditor.opArray = a;
	}
}

ColumnFilterEditor.prototype.createDateTimeExpression = function(sValue, tEditor)
{
   var t = tDTP.parseDateTime(sValue);
   if (t == null) // try date and turn into datetime
   {
      t = tDTP.parseDate(sValue);
      if (t != null)
         t = tDTP.parseDateTime(sValue + " 00:00:00");
   }

   if (t != null && tEditor != null && tEditor.nDisplayToDataTZOffset)
   {  // convert datetime
      t.adjustTimeZoneOffset(tEditor.nDisplayToDataTZOffset);
   }

	return t != null ? t.asXml() : null;
}

ColumnFilterEditor.prototype.createDateExpression = function(sValue)
{
   var t = tDTP.parseDate(sValue);

	return t != null ? t.asXml() : null;
}

ColumnFilterEditor.prototype.createTimeExpression = function(sValue)
{
   var t = tDTP.parseTime(sValue);

	return t != null ? t.asXml() : null;
}

ColumnFilterEditor.prototype.createSqlExpression = function(sValue)
{
   var t = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

	XUISetElementText(t,sValue);
	XUISetXsiType(t, saw.xml.kSawxNamespace,'sqlExpression');

	return t;
}

ColumnFilterEditor.prototype.createVariableExpression = function(sValue)
{
   var t = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

	XUISetElementText(t,sValue);
	XUISetXsiType(t, saw.xml.kSawxNamespace,'variable');
	t.setAttribute('op','server');
	return t;
}

ColumnFilterEditor.prototype.createWebVariableExpression = function(sValue)
{
   var t = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

   // no validation for now
      
	XUISetElementText(t,sValue);
	XUISetXsiType(t, saw.xml.kSawxNamespace,'eval');
	return t;
}

ColumnFilterEditor.prototype.createStringExpression = function(sValue)
{
   var t = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

	XUISetElementText(t,sValue.match(/^(.*\S)\s*$/)[1]);
	XUISetXsiType(t, saw.xml.kXsdNamespace,'string');

	return t;
}

ColumnFilterEditor.prototype.createUntypedExpression = function(sValue)
{
   var t = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

	XUISetElementText(t,sValue);
	XUISetXsiType(t, saw.xml.kSawxNamespace,'untypedLiteral');

	return t;
}


ColumnFilterEditor.prototype.createDecimalExpression = function(sDisplayValue)
{
   var t = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

	var sValue = sDisplayValue.replace(g_LocaleInfo.sDecimalPoint,'.');

	var a = sValue.match(/^\s*([+\-]?[0-9]+(?:\.[0-9]*)?(?:[Ee][+\-]?[0-9]+)?)\s*$/);

	if(a != null)
	{
	   XUISetElementText(t,a[1]);
	   XUISetXsiType(t, saw.xml.kXsdNamespace,'decimal');
	} else return null;

	return t;
}


ColumnFilterEditor.prototype.createIntegerExpression = function(sValue)
{
   var t = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

	var a = sValue.match(/^\s*([+\-]?[0-9]+(?:[Ee][+\-]?[0-9]+)?)\s*$/);

	if(a != null)
	{
	   XUISetElementText(t,a[1]);
	   XUISetXsiType(t, saw.xml.kXsdNamespace,'decimal');
	} else return null;

	return t;
}

ColumnFilterEditor.prototype.createDoubleExpression = function(sValue)
{
   var t = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

	XUISetElementText(t,sValue);
	XUISetXsiType(t, saw.xml.kXsdNamespace,'double');

	return t;
}

ColumnFilterEditor.prototype.createDefaultDisplayValue = function(sType, sValue, sOptArg)
{
   var sDisplayValue = sValue;

   switch(sType)
   {
		case 'sawx:untypedLiteral':
	   case 'xsd:string':
	   default:
		   return {valueType: this.idealValueType, displayValue:sValue, expressionFactory:this.defaultExpressionCreator};

	   case 'xsd:decimal':
	   case 'xsd:double':
	   case 'xsd:float':
	      sDisplayValue = sValue.replace('.',g_LocaleInfo.sDecimalPoint);

		   return {valueType: this.idealValueType, displayValue:sDisplayValue, expressionFactory:this.defaultExpressionCreator};

		case 'sawx:sqlExpression':
		   return {valueType: sType, displayValue:sValue,expressionFactory:this.createSqlExpression,
		      valueTypeDisplay:kmsgFilterEditorExpression, invalidValueDisplay:kmsgFilterEditorInvalidSqlExpressionInput};

		case 'sawx:variable':
		   // historically, we handled both server and session variables as the same type, so we're having to look for
		   // NQ_SESSION to distinguish between the two so user doesn't have to type it in
         if (null != sOptArg && sOptArg == 'session')
		      sDisplayValue = "NQ_SESSION." + sValue;
		      
         return {valueType: sType, displayValue:sDisplayValue,expressionFactory:this.createVariableExpression,
            valueTypeDisplay:kmsgFilterEditorServerVariable,invalidValueDisplay:kmsgFilterEditorInvalidVariableInput};

		case 'sawx:eval':
		   return {valueType: sType, displayValue:sValue,expressionFactory:this.createWebVariableExpression,
		      valueTypeDisplay:kmsgFilterEditorWebVariable,invalidValueDisplay:kmsgFilterEditorInvalidWebVariableInput,
		      defaultValue:sOptArg};

	   case 'xsd:date':
	      var tDate = DateTimeParser.parseXmlDate(sValue);

	      if(tDate != null)
	      {
	         sDisplayValue = tDTP.formInputString(tDate);
	      }

		   return {valueType: this.idealValueType, displayValue:sDisplayValue, expressionFactory:this.defaultExpressionCreator};

      case 'xsd:time':
	      var tTime = DateTimeParser.parseXmlTime(sValue);

	      if(tTime != null)
	         sDisplayValue = tDTP.formInputString(tTime);

	      return {valueType: this.idealValueType, displayValue:sDisplayValue, expressionFactory:this.defaultExpressionCreator};

	   case 'xsd:dateTime':
	      var tDateTime = DateTimeParser.parseXmlDateTime(sValue);

	      if(tDateTime != null)
	         sDisplayValue = tDTP.formInputString(tDateTime);

	      return {valueType: this.idealValueType, displayValue:sDisplayValue, expressionFactory:this.defaultExpressionCreator};
	}

}


ColumnFilterEditor.prototype.createDateTimeDisplayValue = function(sType, sValue)
{
   var sDisplayValue = sValue;

   switch(sType)
   {
		case 'sawx:untypedLiteral':
	   case 'xsd:string':
	   default:
	      var tDate = tDTP.parse(sValue,1|2|4);

	      if(tDate != null)
	      {
	         sDisplayValue = tDTP.formInputString(tDate);
	      }

		   return {valueType: this.idealValueType, displayValue:sDisplayValue, expressionFactory:this.defaultExpressionCreator};

		case 'sawx:sqlExpression':
		   return {valueType: sType, displayValue:sValue,expressionFactory:this.createSqlExpression,
		      valueTypeDisplay:kmsgFilterEditorExpression, invalidValueDisplay:kmsgFilterEditorInvalidSqlExpressionInput};

		case 'sawx:variable':
		   return {valueType: sType, displayValue:sValue,expressionFactory:this.createVariableExpression,
		      valueTypeDisplay:kmsgFilterEditorServerVariable, invalidValueDisplay:kmsgFilterEditorInvalidVariableInput};

		case 'sawx:eval':
		   return {valueType: sType, displayValue:sValue,expressionFactory:this.createWebVariableExpression,
		      valueTypeDisplay:kmsgFilterEditorWebVariable, invalidValueDisplay:kmsgFilterEditorInvalidWebVariableInput};

	   case 'xsd:date':
	      var tDate = DateTimeParser.parseXmlDate(sValue);

	      if(tDate != null)
	      {
	         sDisplayValue = tDTP.formInputString(tDate);
	      }

		   return {valueType: this.idealValueType, displayValue:sDisplayValue, expressionFactory:this.defaultExpressionCreator};

      case 'xsd:time':
	      var tTime = DateTimeParser.parseXmlTime(sValue);

	      if(tTime != null)
	         sDisplayValue = tDTP.formInputString(tTime);

	      return {valueType: this.idealValueType, displayValue:sDisplayValue, expressionFactory:this.defaultExpressionCreator};

	   case 'xsd:dateTime':
	      var tDateTime = DateTimeParser.parseXmlDateTime(sValue);

	      if(tDateTime != null)
	      {
	         if (this.nDisplayToDataTZOffset)
	            tDateTime.adjustTimeZoneOffset(-this.nDisplayToDataTZOffset);
	         
	         sDisplayValue = tDTP.formInputString(tDateTime);
	      }

	      return {valueType: this.idealValueType, displayValue:sDisplayValue, expressionFactory:this.defaultExpressionCreator};
	}

}

//-------------------
// xmlElement is the expr to edit or create.  It should have a formula when
// called.
ColumnFilterEditor.prototype.load = function(xmlElement, criteriaElement)
{
	XUICheckNodeName("ColumnFilterEditor.prototype.load", xmlElement, "sawx:expr");
	XUICheckNodeName("ColumnFilterEditor.prototype.load", criteriaElement, "saw:criteria");

	this.element = xmlElement;
	this.criteria = criteriaElement;
	this.filterColumn = saw.getFirstChildElement(xmlElement);

	var sFormula = "";
	if (this.filterColumn.nodeName == "saw:columnRef")
	{
	   var tColumn = this.criteria.selectSingleNode("saw:columns/saw:column[@columnID='" + XUIGetAttributeString(this.filterColumn, "columnID") + "']");
	   if (tColumn != null)
	      sFormula = XUIGetAttributeString(tColumn, "formula");
	   else
	      alert('column id not found');
	}
	else if (XUIGetXsiType(this.filterColumn, "") == "binExpression")
	   sFormula = XUIGetAttributeString(this.filterColumn, "formula");
	else
	   sFormula = XUIGetElementText(this.filterColumn);

   if (sFormula.length <= 0)
      alert('Invalid Formula');

	this.form.Formula.value = sFormula;

	ColumnFilterEditor.initializeOperatorList();

	// find the corresponding columnspace
	var tInfo = XUIColumnSpace.findInfo(null, sFormula);

   this.category = tInfo != null ? XUIColumnSpace.getInfoSQLAttr(tInfo, "category") : "unknown";
	this.primaryType = tInfo != null ? XUIColumnSpace.getInfoSQLAttr(tInfo, "primaryType") : "unknown";
   this.aggType = tInfo != null ? XUIColumnSpace.getInfoSQLAttr(tInfo, "aggType") : "unknown";
   
   if (this.primaryType == 'timeStamp')
   {
      //timezone info for timestamps
      if (tInfo != null)
      {
         this.sDataTZOffset = XUIColumnSpace.getInfoSQLAttr(tInfo, "timeZone");
         this.sDisplayTZ = saw.tz.getDisplayTimeZone(tInfo, this.criteria); //'(GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi';
         this.nDisplayToDataTZOffset = saw.tz.getDisplayToDataTZOffset(tInfo, this.sDisplayTZ);//-480;
      }
      else
      {
         this.sDataTZOffset = saw.tz.kUnknownOffset;
         this.sDisplayTZ = saw.tz.kUnknownID;
         this.nDisplayToDataTZOffset = 0;
      }
   }

   this.idealValueType = 'sawx:untypedLiteral';
   this.createDisplayValue = this.createDefaultDisplayValue;
   this.defaultExpressionCreator = this.createUntypedExpression;
   this.choiceType = 'sawx:untypedLiteral';
   this.defaultInvalidValueDisplay = kmsgFilterEditorInvalidInput;

   switch(this.primaryType)
   {
      case 'date':
         this.idealValueType = 'xsd:date';
         this.defaultExpressionCreator = this.createDateExpression;
         this.createDisplayValue = this.createDateTimeDisplayValue;

         var tDate = new SAWDateTime;
         tDate.year = 2003;
         tDate.month = 11;
         tDate.day = 30;
         this.defaultInvalidValueDisplay = kmsgFilterEditorInvalidDateInput.replace('%1',tDTP.formInputString(tDate));

         break;
      case 'time':
         this.idealValueType = 'xsd:time';
         this.defaultExpressionCreator = this.createTimeExpression;
         this.createDisplayValue = this.createDateTimeDisplayValue;

         var tDate = new SAWDateTime;
         tDate.hour = 23;
         tDate.minute = 30;
         tDate.second = 58;
         this.defaultInvalidValueDisplay = kmsgFilterEditorInvalidTimeInput.replace('%1',tDTP.formInputString(tDate));
         break;
      case 'timeStamp':
         this.idealValueType = 'xsd:dateTime';
         this.defaultExpressionCreator = this.createDateTimeExpression;
         this.createDisplayValue = this.createDateTimeDisplayValue;
         var tDate = new SAWDateTime;
         tDate.year = 2003;
         tDate.month = 11;
         tDate.day = 30;
         tDate.hour = 23;
         tDate.minute = 30;
         tDate.second = 58;
         this.defaultInvalidValueDisplay = kmsgFilterEditorInvalidDateTimeInput.replace('%1',tDTP.formInputString(tDate));
         break;
      case 'text':
         this.idealValueType = 'xsd:text';
         this.defaultExpressionCreator = this.createStringExpression;
         break;

      default:
         if(this.category == 'numeric')
         {
            this.idealValueType = 'xsd:decimal';
            this.defaultExpressionCreator = this.createDecimalExpression;

            if(this.primaryType == 'integer')
               this.defaultExpressionCreator = this.createIntegerExpression;
            break;
         }
   };

	// show the column being edited
	var sDisplayHdg = XUIColumnSpace.getInfoHeading(tInfo, "saw:columnHeading", 40);
	if (sDisplayHdg == "")
	{
	   // try to use the displayFormula
	   var sqlInfo = (tInfo != null)? tInfo.selectSingleNode("saw:SQLInfo") : null;
      if(sqlInfo)
      {
         var sDisplayFormula = XUIGetAttributeString(sqlInfo, "displayFormula");
         if(sDisplayFormula != "")
         {
            sDisplayHdg = XUIColumn.getDisplayHeadingFromFormula(sDisplayFormula);
         }
      }

      if(sDisplayHdg == "")
         sDisplayHdg = XUIColumn.getDisplayHeadingFromFormula(sFormula, 40);
   }

	document.getElementById('idColumnFilterColumnName').innerHTML = sDisplayHdg;

   // timezone info
   var tTzCell = document.getElementById('idColumnFilterColumnTimeZone');
   if (tTzCell != null)
   {
      if (this.primaryType == 'timeStamp')
      {
         tTzCell.style.display = "";
         var vDivs = tTzCell.getElementsByTagName('DIV');
         // assume only one DIV
         if (vDivs.length > 0)
         {
            var sTZInfo = kmsgEditFormatDataTimeZoneOffset + ': <b>' + saw.tz.offsetToString(saw.tz.getDataTZOffset(tInfo)) + '</b><br>' 
               + kmsgEditFormatDisplayTimeZone + ': <b>' + saw.tz.getTimeZoneNameByID(this.sDisplayTZ) + '</b>';
            vDivs[0].innerHTML = sTZInfo;
         }
      }
      else
      {
         tTzCell.style.display = "none";
      }
   }
   
	if (this.aggByTableLink != null)
	{
	   // Hide aggBy link if another column is already aggregated or if this is a non-agg columns
	   if (this.aggType == "agg")
	   {
	      var tExpr = this.criteria.selectSingleNode("//sawx:expr[@aggBy0]");
	      if (tExpr != null && this.filterColumn.getAttribute("aggBy0") == null)  // aggBy0 exists somewhere and it's not me
	         this.aggByTableLink.style.display = "none";
	      else
	         this.aggByTableLink.style.display = "";

	   } else
	      this.aggByTableLink.style.display = "none";
	   this.tAggByFilterEditor = new AggByFilterEditor('idAggByFilter', sDisplayHdg);
	}

	// Add only the operators that apply as options
	var tOptions = this.form.Operator.options;
	var sCurrentOp = this.element.getAttribute("op");
	if (sCurrentOp == "equal")
	   sCurrentOp = "in";

	tOptions.length = 0;
	for (op in ColumnFilterEditor.opArray)
	{
		var tProps = ColumnFilterEditor.opArray[op];
		if (!tProps.textOnly || (this.category == "text") || (this.category == "unknown"))
		{
		   if (!this.conditionalFormatting || tProps.conditional)
		   {
          if (!(op == 'prompted' && this.bNoPromptedOp))
          {
			       var tNew = new Option(tProps.display, op);
			       tOptions[tOptions.length] = tNew;
			       tNew.selected = (op == sCurrentOp);
			    }
			 }
		}
	}

	this.choicesDiv.innerHTML = "";
	this.choicesForm.Constraint.value = "";
	this.choicesForm.BetweenA.value = "";
	this.choicesForm.BetweenB.value = "";

	this.currentValues = new Array();

   for(var i = 0 ; i < this.valuesTable.rows.length - 1;)
	{
	   this.valuesTable.deleteRow(i);
	}
		
   // first child can be a sawx:expr or a saw:columnRef so use firstChild not select sawx:expr
   var txv = saw.getFirstChildElement(this.element);
   if (txv != null)
   {
      txv = saw.getNextSiblingElement(txv);
      while (txv != null)
      {
         this.drawValueExpr(txv, null);
         txv = saw.getNextSiblingElement(txv);
      }
   }

	// Handle conditional formatting UI
//	var sDisplay = this.conditionalFormatting ? "none" : "";
//	document.getElementById(this.myId + 'AddCell').style.display = sDisplay;
//	var t = document.getElementById(this.myId + 'ExtraButtonSpan');
//	if (t != null)
//	   t.style.display = sDisplay;

	this.morphUI();

	this.drawAggByRows();
}

//-------------------
ColumnFilterEditor.prototype.apply = function(bVerbose)
{
   bVerbose = bVerbose != false;

	// validate the expression
	var tProps = this.currentProps;

	var t = this.filterColumn.nextSibling;

	while(t != null)
	{
	   var t2 = t;

	   t=t.nextSibling;

	   if(t2.nodeName == 'sawx:expr')
	   {
	      this.element.removeChild(t2);
	   }
	}

	var nCount = 0;
	for(var i = 0 ; i < this.valuesTable.rows.length - 1; ++i)
	{
	   var tInput = this.valuesTable.rows[i].inputField;

	   var tRE = new RegExp("^\\s*$");
	   if(tRE.test(tInput.value) == false)   // ignore blank values
	   {
	      ++nCount;

	      var t = null;
	      var sError = tInput.invalidValueDisplay; // changed below if top or bottom

	      // Top and bottom always take an integer
	      if ((tProps.op == "top") || (tProps.op == "bottom"))
	      {
	         t = this.createDecimalExpression(tInput.value);
	         sError = kmsgFilterEditorInvalidInput;
	      }
	      else
	         t = tInput.expressionFactory(tInput.value, this);
	         
         // add default to presentation variables
         if(t != null && tInput.valueType == "sawx:eval")
         {
            var tDefaultField = this.valuesTable.rows[i].defaultField;
            if(tDefaultField != null && tDefaultField.value != null && tDefaultField.value != "")
               t.setAttribute('default', tDefaultField.value);
         }                    

         // check if we need to prepend NQ_SESSION.
         if(t != null && tInput.valueType == "sawx:variable" && this.valuesTable.rows[i].nqsession == true)
         {
            var sValue = "NQ_SESSION." + XUIGetElementText(t);
            XUISetElementText(t,sValue);
         }

	      if(t == null)
	      {
	         if(bVerbose)
	         {
	            tInput.focus();
	            alert(sError);
            }

	         return false;
	      }
	      else
	      {
	         this.element.appendChild(t);
         }
	   }
	}

	if (nCount < tProps.minValues)
	{
	   if(bVerbose)
   		alert(XUIFormatMessage(kmsgFilterEditorTooFewValues, new Array(tProps.display, tProps.minValues)));
		return false;
	}

	if (nCount > tProps.maxValues)
	{
	   if(bVerbose)
		   alert(XUIFormatMessage(kmsgFilterEditorTooManyValues, new Array(tProps.display, tProps.maxValues)));
		return false;
	}

   // Convert in to equal if only one value
   if ((tProps.op == "in") && (nCount == 1))
   {
	   XUISetXsiType(this.element, saw.xml.kSawxNamespace, 'comparison');
	   this.element.setAttribute("op", "equal");
   }
   else
   {
      XUISetXsiType(this.element, null, tProps.xsiType);
	   this.element.setAttribute("op", tProps.op);

   	// If isprompted, make sure its not protected
   	if (tProps.op == "prompted")
   	   this.element.removeAttribute("protected");
	}

	return true;
}

//-------------------
ColumnFilterEditor.prototype.discard = function()
{
   if (null != this.parentEditor &&
       (this.parentEditor.creatingNewFilterCriteria ||
        this.parentEditor.editingExistingFilterCriteria))
   {
      // make sure that the subquery filter editor is not open
      if (!XUIDialog.isVisible ('idSubQueryFilter'))
	      this.parentEditor.discard();
	}
}

//-------------------
ColumnFilterEditor.prototype.onChildApply = function(source)
{
   if (source == this.webExpressionSelector)
   {
      // webExpr, webExprDefaultValue and webExprUseQuote should have been set
      // by the child WebExpressionSelector editor
      if (null != this.webExpr &&
          null != this.webExprDefaultValue &&
          null != this.webExprUseQuotes)
      {
         var sQuote = (this.webExprUseQuotes == true) ? "'" : "";

         var sValue = sQuote + "@{" + this.webExpr + "}{";

         sValue += this.webExprDefaultValue + "}" + sQuote;

         var tNewRow = this.addTypedValue (this.createDisplayValue ('sawx:sqlExpression', ''));
         if (null != tNewRow &&
             null != tNewRow.inputField)
            tNewRow.inputField.value = sValue;

         this.webExpr = null;
         this.webExprDefaultValue = null;
         this.webExprUseQuotes = null;
      }
   }

   if (source == this.tAggByFilterEditor)
      this.drawAggByRows ();
}

//-------------------
// The first child is the column
ColumnFilterEditor.prototype.numValues = function()
{
   // vars can have defaults, we need to count the rows instead of the elements
   var c = 0;
   
   for(var i = 0; i < this.valuesTable.rows.length; ++i)
      if (this.valuesTable.rows[i].inputField)
         ++c;
   
   return c;
}

//-------------------

var g_nValueID = 1;

ColumnFilterEditor.prototype.addTypedValue = function(tValue)
{
   var tBlankRow = null;

   for(var i = 0 ; i < this.valuesTable.rows.length - 1; ++i)
   {
      var tRow = this.valuesTable.rows[i];

      if(tRow.inputField.value == '' && ((tValue.displayValue == '' || tValue.displayValue == "NQ_SESSION.") ^ tValue.valueType == tRow.inputField.valueType))
      {
         if(tBlankRow == null)
            tBlankRow = tRow;
      } else if(tValue.valueType == tRow.inputField.valueType && tValue.displayValue == tRow.inputField.value)
      {
         tRow.inputField.focus();
         return tRow;
      }
   }

   if(tBlankRow != null)
   {

       tBlankRow = this.drawValueRow(tValue, tBlankRow);

       tBlankRow.inputField.focus();

       return tBlankRow;
   }

   if(this.numValues() < this.currentProps.maxValues)
   {
      var tRow = this.drawValueRow(tValue);

      tRow.inputField.focus();
      return tRow;
   }

   return null;
}

ColumnFilterEditor.prototype.drawValueExpr = function(tExpr, tRow)
{
   // defaults for presentation variables
   var sDefault = null;
   
   if(tExpr.getAttribute('xsi:type') == 'sawx:eval')
      sDefault = tExpr.getAttribute('default');
   this.drawValueRow(this.createDisplayValue(tExpr.getAttribute('xsi:type'), XUIGetElementText(tExpr), sDefault), tRow);
}

ColumnFilterEditor.prototype.alignValueRowCells = function()
{
   var nBottomWidth = 0;
   // find the width of the operator cell in the bottom values table
   {
      var tCell = this.valuesTable.rows[this.valuesTable.rows.length - 1].cells[0];
      nBottomWidth = tCell.offsetWidth;
   }

   if (nBottomWidth > 0)
   {
      var tTopOperatorCaptionCell = document.getElementById(this.myId + "TopOperatorCaptionCell");
      if (null != tTopOperatorCaptionCell)
         tTopOperatorCaptionCell.style.width = nBottomWidth-6 +"px";
   }
}

ColumnFilterEditor.prototype.drawValueRow = function(tValueStruct, tRow)
{
   if(tRow == null)
   {
      tRow = this.valuesTable.insertRow(this.valuesTable.rows.length - 1);
      tRow.insertCell(tRow.cells.length);
      tRow.insertCell(tRow.cells.length);
   }

    var sValue = tValueStruct.valueTypeDisplay != null ?
      tValueStruct.valueTypeDisplay : kmsgFilterEditorValue;
      
   if (tValueStruct.valueType == "sawx:eval")
      sValue += "<br/><span class=\"FilterValueSubtleSpan\">" + kmsgFilterEditorWebVariableDefault + "</span>";
	else if ((tValueStruct.valueType == "sawx:variable") && (tValueStruct.displayValue.indexOf("NQ_SESSION.") == 0))
      sValue = kmsgFilterEditorSessionVariable;

   tRow.cells[0].innerHTML = sValue;

   tRow.cells[0].className = "XUIPromptCaption";
   tRow.cells[0].style.paddingtop = "0px";
   tRow.cells[0].style.paddingBottom = "0px";
   tRow.cells[0].style.lineHeight = "200%"; // for pres default

   var i = g_nValueID++;

   var sCalendar = "";
	if(tValueStruct.valueType == 'xsd:date')
	{
		sCalendar += '&nbsp;<A onclick="javascript:ColumnFilterEditor.showCalendar(' + i + ',\'' + this.myId + '\', event)"><img src="' + kImgColumnFilterCalendarGIF + '" align="center" ID="dateimg1" border="0" style="cursor:pointer;"></A>';
	}

	// only delete if we have more than the minimum
	var sDelete = "&nbsp;<a href='#' onclick='ColumnFilterEditor.onClickDelete(" + i + "); return false;'><img border=0 src='" + kimgDelete + "' align='center'></a>";

	// We need to escape the value
	var sInputValue;
	if(tValueStruct.valueType == 'sawx:sqlExpression' || tValueStruct.valueType == 'sawx:variable')
	   sInputValue = "<input dir='ltr' name='Value" + i + "' type='text' size='23' value='' onkeypress='valueKeyPress(event)'>" + sCalendar + sDelete;
	else
	   sInputValue = "<input name='Value" + i + "' type='text' size='23' value='' onkeypress='valueKeyPress(event)'>" + sCalendar + sDelete;

   // for presentation variables add defaults
	if(tValueStruct.valueType == "sawx:eval")
	   sInputValue += "<br/><input id='Default" + i + "' type='text' value='' size='23'>";
   
   tRow.cells[1].innerHTML	= sInputValue;

   if ((tValueStruct.valueType == "sawx:eval") && (tValueStruct.defaultValue != null))
   {
      var tDfltInput = document.getElementById("Default" + i);
      if (tDfltInput != null)
         tDfltInput.value = tValueStruct.defaultValue;
   }

   var sDisplayValue = tValueStruct.displayValue;
	if ((tValueStruct.valueType == "sawx:variable") && (sDisplayValue.indexOf("NQ_SESSION.") == 0))
   {
	   sDisplayValue = sDisplayValue.substr(11, sDisplayValue.length);
	   tRow.nqsession = true;
	}
	   
   tRow.cells[1].childNodes[0].value = sDisplayValue;
   tRow.cells[1].childNodes[0].expressionFactory = tValueStruct.expressionFactory;
   tRow.cells[1].childNodes[0].valueType = tValueStruct.valueType;
   tRow.cells[1].childNodes[0].invalidValueDisplay = tValueStruct.invalidValueDisplay != undefined ?
      tValueStruct.invalidValueDisplay  : this.defaultInvalidValueDisplay;
   
   tRow.cells[1].childNodes[0].defaultValue = tValueStruct.defaultValue != undefined ? 
      tValueStruct.defaultValue : null;

   tRow.cells[1].className = "XUIPromptEntry";
   tRow.cells[1].style.paddingtop = "0px";
   tRow.cells[1].style.paddingBottom = "0px";
   tRow.cells[1].colSpan = 2;
   tRow.cells[1].noWrap = true;

   tRow.inputField = tRow.cells[1].childNodes[0];
   tRow.defaultField = document.getElementById("Default" + i);
   

   this.alignValueRowCells();

   return tRow;
}

ColumnFilterEditor.findCellForCalendar = function(event)
{
	tObj = saw.getEventTarget(event);

	while(tObj != null && tObj.tagName != 'TD')
		tObj = saw.getParentElement(tObj);

	if(tObj == null)
		alert('Unable to find cell for Calendar');

	return tObj;
}

ColumnFilterEditor.showCalendar = function(nValue, eid, event)
{
   var tEditor = XUIPanel.getEditor(eid);

	saw.stopEventPropagation(event);

   var tInput = null;

	if (nValue == null)
		tInput = tEditor.form.elements[tEditor.form.elements.length-1];
   else
      tInput = tEditor.form.elements["Value"+nValue];

	if(tInput.valueType != 'xsd:date')
		tInput = null;

   // does this need to be set??
   var tPrevInput = null;
	NQCShowCalendar(saw.getEventTarget(event), tInput, tPrevInput, null, false, null, nqcalmns, nqdfmt, nqdsep);
}

ColumnFilterEditor.prototype.getExprDisplayValueText = function(tExpr)
{
   var sType = tExpr.getAttribute('xsi:type');
   var sValue = XUIGetElementText(tExpr);

   return this.getDisplayValueText(sType,sValue);
}

//-------------------
ColumnFilterEditor.prototype.removeValue = function(nValue)
{
   var tInput = null;

	if (nValue == null)
		tInput = this.form.elements[this.form.elements.length-1];
   else
      tInput = this.form.elements["Value"+nValue];

   if(tInput != null)
   {
		if (this.numValues() > this.currentProps.minValues)
		{
		   var nRow = saw.getParentElement(saw.getParentElement(tInput)).rowIndex;

		   this.valuesTable.deleteRow(nRow);
		   this.alignValueRowCells();
		}
		else // just clear the field (and default if present)
		{
			tInput.value = '';
			
			tInput = this.form.elements["Default"+nValue];
			if (tInput != null)
			   tInput.value = '';
		}
	}
}

//-------------------
ColumnFilterEditor.prototype.clearValues = function()
{
	while (this.valuesTable.rows.length > 1)
		this.valuesTable.deleteRow(0);

	this.morphUI();
}

//-------------------
ColumnFilterEditor.prototype.morphUI = function()
{
	// Get the properties of the currently selected option
	var sChoice = this.form.Operator.options[this.form.Operator.selectedIndex].value;
	this.currentProps = ColumnFilterEditor.opArray[sChoice];

	// Add the minimum number of boxes
	while (this.numValues() < this.currentProps.minValues)
	{
	   this.drawValueRow(this.createDisplayValue('sawx:untypedLiteral',''));
	}

  for(var i = this.currentProps.maxValues ; i < this.valuesTable.rows.length - 1;)
  {
      if(this.valuesTable.rows[i].inputField.value == '')
      {
         this.valuesTable.deleteRow(i);
      } else
         ++i;
  }

   this.alignValueRowCells();

	// Hide appropriate elements on the right
	if ((this.currentProps.maxValues == 0) || (this.currentProps.choices == false))
		this.choicesSide.style.display='none';

	else
	{
	   if(this.aggType == 'nonAgg')
	   {
   	   this.choicesSide.style.display='';
		   switch (this.category)
		   {
			   case "text":
				   this.matchTable.style.display='';
				   this.betweenTable.style.display='none';
				   break;
			   case "calendar":
				   this.matchTable.style.display='none';
				   this.betweenTable.style.display='';
				   break;
			   default:
				   this.matchTable.style.display='none';
				   this.betweenTable.style.display='none';
				   break;
		   }
	   } else
	   {
	      this.choicesSide.style.display='none';
			this.matchTable.style.display='none';
			this.betweenTable.style.display='none';
	   }
	}

	// if list format and derived criteria, do not show choices
	if (this.bIsListFormat && XUIGetXsiType(this.criteria) == "derived")
	{
	   this.choicesSide.style.display='none';
		this.matchTable.style.display='none';
		this.betweenTable.style.display='none';
	}
}

//-------------------

ColumnFilterEditor.prototype.sqlEscape = function(sValue)
{
   return sValue.replace(/'/g, "''")
}

function XUICalculateXmlPosition(tParentElement, tChild)
{
   if(tParentElement != tChild)
   {
      var n = 0;
      for(var e = tParentElement.firstChild ; e != null ; e = e.nextSibling, ++n)
      {
         if(e == tChild)
         {
            return [n];
         }

         var b = XUICalculateXmlPosition(e, tChild);

         if(b != null)
            return [n].concat(b);
      }
   }

   return null;
}

function XUIApplyXmlPosition(tParentElement, a, pos)
{
   if(a == null || pos >= a.length)
      return tParentElement;

   if(pos == null)
      pos = 0;

   var e = tParentElement.firstChild;

   for(var i = 0 ; i != a[pos]; ++i)
      e = e.nextSibling;

   return XUIApplyXmlPosition(e, a, pos+1);
}


ColumnFilterEditor.prototype.displayChoices = function(bLimited)
{
	var aColumns =	new Array;
	aColumns[0] = this.form.Formula.value;

	// Interpret match or between entries
	var sWhere = null;

	if(this.matchTable.style.display == '')
	{
	   if (this.choicesForm.Constraint.value != "")
	   {
		   var sValue = null;
		   switch (this.choicesForm.Match.value)
		   {
			   case "beginsWith":
				   sValue = this.sqlEscape(this.choicesForm.Constraint.value) + "%";
				   break;
			   case "endsWith":
				   sValue = "%" + this.sqlEscape(this.choicesForm.Constraint.value);
				   break;
			   case "contains":
				   sValue = "%" + this.sqlEscape(this.choicesForm.Constraint.value) + "%";
				   break;
		   }
	      if (sValue != null)
		   {
				 if (typeof g_CaseInsensitiveSearch != "undefined" && g_CaseInsensitiveSearch == "true" )
							sWhere = "UPPER(" + aColumns[0] + ") LIKE UPPER('" + sValue + "')";
				 else
							sWhere =  aColumns[0] + " LIKE '" + sValue + "'";
			}
	   }
	}
	else if(this.betweenTable.style.display == '')
	{
	   var tA = null;
	   var tB = null;

	   switch(this.primaryType)
	   {
	      case 'date':
	         tA = tDTP.parse(this.choicesForm.BetweenA.value, 2 | 8 | 16 | 32);
	         tB = tDTP.parse(this.choicesForm.BetweenB.value, 2 | 8 | 16 | 32);
	         break;
	      case 'time':
	         tA = tDTP.parse(this.choicesForm.BetweenA.value, 4);
	         tB = tDTP.parse(this.choicesForm.BetweenB.value, 4);
	         break;
	      case 'timeStamp':
	         // convert
	         tA = tDTP.parse(this.choicesForm.BetweenA.value, 1 | 2 | 4 | 8 | 16 | 32);
	         tB = tDTP.parse(this.choicesForm.BetweenB.value, 1 | 2 | 4 | 16 | 32);
	         //convert to data timezone
	         if (this.nDisplayToDataTZOffset)
	         {
	            if (tA != null)
	               tA.adjustTimeZoneOffset(this.nDisplayToDataTZOffset);
	            if (tB != null)
	               tB.adjustTimeZoneOffset(this.nDisplayToDataTZOffset);
	         }
	         break;
	   }

	   if(tA != null)
	   {
	      var sA = DateTimeParser.buildDateTimeClause('>', this.form.Formula.value, this.primaryType, tA);

         if(sA != null)
	         sWhere = sA;
      }

	   if(tB != null)
	   {
	      var sA = DateTimeParser.buildDateTimeClause('<', this.form.Formula.value, this.primaryType, tB);

         if(sA != null)
	         sWhere = sWhere == null ? sA : (sWhere + ' AND ' + sA);

      }

	}

	if(bLimited)
	{
	   var tExistingFilter = this.criteria.selectSingleNode('saw:filter');

	   var tOuterExpr = tExistingFilter == null ? null : tExistingFilter.selectSingleNode('sawx:expr');

	   if(tExistingFilter && tOuterExpr)
	   {
	      if(this.originalExpr)
	      {

	         var aPosition = XUICalculateXmlPosition(tExistingFilter, this.originalExpr);

	         tExistingFilter = tExistingFilter.cloneNode(true);

	         tOuterExpr = tExistingFilter.selectSingleNode('sawx:expr');

	         var tEditedExpr = XUIApplyXmlPosition(tExistingFilter, aPosition);

	         if(tEditedExpr != null)
	         {
	            var tSQLFilter = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

	            XUISetXsiType(tSQLFilter, saw.xml.kSawxNamespace, 'sql');

	            var bAnd = true;

	            if(tEditedExpr.parentNode.getAttribute('op') == 'or')
	               bAnd = false;

	            XUISetElementText(tSQLFilter, bAnd ? '1 = 1' : '1 = 0');

	            tEditedExpr.parentNode.replaceChild(tSQLFilter, tEditedExpr);
	         }
	      }

	      if(sWhere != null)
	      {
	         var tNewFilter = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

	         XUISetXsiType(tNewFilter, saw.xml.kSawxNamespace, 'logical');

	         tNewFilter.setAttribute('op','and');

	         tNewFilter.appendChild(tOuterExpr.cloneNode(true));

	         var tSQLFilter = XUICreateElement(saw.xml.kSawxNamespace, 'expr');

	         XUISetXsiType(tSQLFilter, saw.xml.kSawxNamespace, 'sql');

	         XUISetElementText(tSQLFilter, sWhere);

	         tNewFilter.appendChild(tSQLFilter);

	         sWhere = tNewFilter;
	      }
	      else
	         sWhere = tOuterExpr;

      }
	}
	//iterate this.criteria to fetch the column display format
	  var dispalyFormat;
	  var sdispalyFormatNode = "saw:displayFormat";
	  var saw_Columns = this.criteria.childNodes; //saw:columns
	  
	  for(iCol =0;iCol<saw_Columns[0].childNodes.length;iCol++) //saw:columns/column length
	  {
	    var saw_column = saw_Columns[0].childNodes;  //list of columns
	    if(saw_column[iCol].getAttribute('formula') == this.form.Formula.value) //Check the current column
	    {
	       //Good here
		   for(iFrmt = 0;iFrmt < saw_column[iCol].childNodes.length;iFrmt++)
		    {
			   
			   if(sdispalyFormatNode == saw_column[iCol].childNodes[iFrmt].nodeName) //if node is dispalyFormat then true
			    {
	 	          dispalyFormat = saw_column[iCol].childNodes[iFrmt];  
				  break;
				}
			}
	 	  break;
	    }
	  }
		

	this.choicesDiv.innerHTML = '';
	VTDisplayValues(this.choicesDiv, aColumns, this.criteria.getAttribute('subjectArea'), 'kmsgColumnFilterValueTableChoice', sWhere, this.sDisplayTZ, this.sDataTZOffset,"","","","","","","","","","","",dispalyFormat);
}

// --- Reorders aggBy XML and redraws the aggregate by rows
ColumnFilterEditor.prototype.drawAggByRows = function()
{
   if (this.aggByTable == null)
      return;

   var a = new Array;

   // Re-order the aggBys in case one was deleted from the middle
   for (i=0; i < ColumnFilterEditor.MAX_AGGBYS; i++)
   {
      var sAggBy = XUIGetAttributeString (this.filterColumn, "aggBy"+i);
      if (sAggBy != "")
         a.push(sAggBy);
      this.filterColumn.removeAttribute("aggBy"+i);
   }

   // Deletes all existing aggBy rows in the table
   for(var i = 0 ; i < this.aggByTable.rows.length ;)
	{
	   this.aggByTable.deleteRow(i);
	}

	// Insert aggBy rows
   for (i=0; i< a.length; i++)
   {
      var tRow = this.aggByTable.insertRow(this.aggByTable.rows.length);
      tRow.insertCell(tRow.cells.length);
      tRow.insertCell(tRow.cells.length);

      tRow.cells[0].setAttribute("class", "XUIPromptCaption");
      tRow.cells[0].style.paddingBottom = "5";
      tRow.cells[0].innerHTML = kmsgFilterEditorAggBy + "&nbsp;";

      var sDelete = "&nbsp;<a href='#' onclick='ColumnFilterEditor.onAggregateByDelete(" + i + "); return false;'><img border=0 align='absmiddle' src='" + kimgDelete + "'></a>";

      tRow.cells[1].setAttribute("class", "XUIPromptStaticText");

      var sTableHdg = XUIColumn.getTableHeadingFromFormula(a[i]);
	   var sColumnHdg = XUIColumn.getColumnHeadingFromFormula(a[i]);

	   tRow.cells[1].innerHTML = "<b>" + sTableHdg + "." + sColumnHdg + "</b>" + sDelete;
      tRow.cells[1].style.paddingBottom = "5";
      this.filterColumn.setAttribute("aggBy"+i,a[i]);
   }
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

//-------------------
ColumnFilterEditor.onChangeOperator = function(eid)
{
	var tEditor = XUIPanel.getEditor(eid);
	tEditor.morphUI();
}

//-------------------
ColumnFilterEditor.onClickDelete = function(nValue)
{
	var tEditor = XUIPanel.getEditor('idColumnFilter');
	tEditor.removeValue(nValue);
}

//-------------------
ColumnFilterEditor.onAddExpr = function(eid, sType, sOptArg)
{
	NQWClearActiveMenu();

	var tEditor = XUIPanel.getEditor(eid);

   tEditor.addTypedValue(tEditor.createDisplayValue(sType,'',sOptArg));
}

//-------------------
ColumnFilterEditor.onAddWebExpr = function(eid)
{
	NQWClearActiveMenu();

	var tEditor = XUIPanel.getEditor(eid);

	var tDialog = new XUIDialog('idWebExprSelector', tEditor.webExpressionSelector, tEditor);

	tDialog.show (tEditor.element, event.clientX-150, event.clientY);
}

//-------------------
ColumnFilterEditor.onAllChoices = function(eid)
{
	var tEditor = XUIPanel.getEditor(eid);
	tEditor.displayChoices();
}

//-------------------
ColumnFilterEditor.onLimitedChoices = function(eid)
{
	var tEditor = XUIPanel.getEditor(eid);
	tEditor.displayChoices(true);
}

//-------------------
ColumnFilterEditor.onClearValues = function(eid)
{
	var tEditor = XUIPanel.getEditor(eid);
	tEditor.clearValues();
}

//-------------------
ColumnFilterEditor.onChoice = function(sChoiceXML)
{
	var tEditor = XUIPanel.getEditor('idColumnFilter');

	// get the value from the sChoiceXML
	var tIsland = saw.getXmlIsland();
	tIsland.loadXML(sChoiceXML);

	var tValueXML = tIsland.selectSingleNode('saw:value');

	var sType = tValueXML.getAttribute('type');

	var sValue = tValueXML.getAttribute('value');

	if(sValue == null)
		sValue = tValueXML.getAttribute('odbcValue');

	// Add the value
	tEditor.addTypedValue(tEditor.createDisplayValue(tEditor.choiceType,sValue));
}

//-------------------
ColumnFilterEditor.onConvertToSql = function(eid, event)
{
	var tEditor = XUIPanel.getEditor(eid);
	tEditor.apply(false, event); // convert regardless of success
   {

      tEditor.eid = eid;

      tEditor.getAdvancedSQL();

   }
   NQWClearActiveMenu();
}


//-------------------
// Called from menu now
ColumnFilterEditor.openSubQueryFilterEditor = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);

   var tSubQueryEditor = new SubQueryFilterEditor('idSubQueryFilter');
	var tDialog = new XUIDialog('idSubQueryFilter', tSubQueryEditor, tEditor.parentEditor);

   if (tEditor.parentEditor)
   {
      if (tEditor.parentEditor.creatingNewFilterCriteria)
         tSubQueryEditor.creatingNewFilterCriteria = tEditor.parentEditor.creatingNewFilterCriteria;
         
      if (tEditor.parentEditor.editingExistingFilterCriteria)
         tSubQueryEditor.editingExistingFilterCriteria = tEditor.parentEditor.editingExistingFilterCriteria;
   }

   XUISetXsiType(tEditor.element, saw.xml.kSawNamespace, 'subQuery');

	tDialog.show(tEditor.element, saw.calcAbsoluteLeft(tEditor.panel.div),  saw.calcAbsoluteTop(tEditor.panel.div), tEditor.criteria);
   
   XUIDialog.cancel(eid);

   NQWClearActiveMenu();
   return false;
}


//-------------------
ColumnFilterEditor.prototype.getAdvancedSQL = function(eid)
{
   this.advancedSQLForm = document.getElementById(this.form.id+'AdvancedSQL');

   this.advancedSQLForm.action = saw.commandToURL('ConvertFilterToSQL');

   this.advancedSQLForm.FilterXML.value = '<nqw><saw:filter xmlns:saw="com.siebel.analytics.web/report/v1">' + this.element.xml + '</saw:filter></nqw>';
   this.advancedSQLForm.SubjectArea.value = this.criteria.getAttribute('subjectArea')
 	 	
 	var req = new sawr.serverRequest("ConvertFilterToSQL", ColumnFilterEditor.loadSQL);
 	
   req.setCallerObj(this);
   
   var conn = new sawr.xhrConnection(req);

   conn.postForm(this.advancedSQLForm);
}

ColumnFilterEditor.loadSQL = function(tData)
{
   var tEditor = tData.getCallerObj();
   var sSql = '';

	var s = tData.getXML().selectSingleNode('sawr:sql');

	if(s)
	{
	   sSql = XUIGetElementText(s);
   }

   XUISetXsiType(tEditor.element, saw.xml.kSawxNamespace, "sql");
	tEditor.element.removeAttribute("op");
	while (tEditor.element.firstChild != null)
	   tEditor.element.removeChild(tEditor.element.firstChild);

	XUISetElementText(tEditor.element, sSql);

	// Close Dialog
	XUIPanel.getPanel(tEditor.eid).close();

	// Show Sql Filter Editor
	tEditor.parentEditor.editFilter(tEditor.element, true);
}

// ---- Specific to segmentation.  Allow user to specify aggregate by --
ColumnFilterEditor.onAggregateBy = function(eid, oEvent)
{
	var tEditor = XUIPanel.getEditor(eid);

	// Check that we have not reached the max number of aggBy values
	if (XUIGetAttributeString (tEditor.filterColumn, "aggBy" + (ColumnFilterEditor.MAX_AGGBYS-1)) != "")
	{
	   alert (kmsgFilterEditorMaxAggByFields);
	   return false;
	}

	var tDialog = new XUIDialog('idAggByFilter', tEditor.tAggByFilterEditor, tEditor);

	tDialog.show(tEditor.filterColumn, -1, -1, null, saw.getEventTarget(oEvent));

   return false;
}

//-------------------
ColumnFilterEditor.onAggregateByDelete = function(nValue)
{
	var tEditor = XUIPanel.getEditor('idColumnFilter');
	tEditor.filterColumn.removeAttribute("aggBy"+nValue);
	tEditor.drawAggByRows();
}

//-------------------
ColumnFilterEditor.initializeAddMenu = function(event, tMenu)
{
   var tEditor = XUIPanel.getEditor('idColumnFilter');

   var tList = tMenu.getElementsByTagName('A');
   for(var i = 0 ; i != tList.length ; ++i)
   {
      if(tList[i].name != 'addvalue' &&
         tList[i].name != 'addvar')
      {
         tList[i].style.display = tEditor.conditionalFormatting ? "none" : "";
      }
   }
}

//-------------------
ColumnFilterEditor.initializeVariableMenu = function(event, tMenu)
{
   var tEditor = XUIPanel.getEditor('idColumnFilter');

   var tList = tMenu.getElementsByTagName('A');
   for(var i = 0 ; i != tList.length ; ++i)
   {
      if(tList[i].name != 'addwebvar')
      {
         tList[i].style.display = tEditor.conditionalFormatting ? "none" : "";
      }
   }
}

